/*
 * Decompiled with CFR 0.152.
 */
package top.theillusivec4.champions;

import com.electronwill.nightconfig.core.CommentedConfig;
import com.google.gson.JsonObject;
import com.mojang.brigadier.CommandDispatcher;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.commands.synchronization.ArgumentSerializer;
import net.minecraft.commands.synchronization.ArgumentTypes;
import net.minecraft.core.Direction;
import net.minecraft.core.Registry;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.client.gui.IIngameOverlay;
import net.minecraftforge.client.gui.OverlayRegistry;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.common.capabilities.RegisterCapabilitiesEvent;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.eventbus.api.IEventBus;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.config.ModConfigEvent;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import org.apache.commons.io.FileUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import top.theillusivec4.champions.api.IChampion;
import top.theillusivec4.champions.api.IChampionsApi;
import top.theillusivec4.champions.api.impl.ChampionsApiImpl;
import top.theillusivec4.champions.client.ChampionsOverlay;
import top.theillusivec4.champions.client.ClientEventHandler;
import top.theillusivec4.champions.client.affix.ClientAffixEventsHandler;
import top.theillusivec4.champions.client.config.ClientChampionsConfig;
import top.theillusivec4.champions.common.affix.core.AffixManager;
import top.theillusivec4.champions.common.capability.ChampionCapability;
import top.theillusivec4.champions.common.config.ChampionsConfig;
import top.theillusivec4.champions.common.integration.theoneprobe.TheOneProbePlugin;
import top.theillusivec4.champions.common.integration.waila.WailaPlugin;
import top.theillusivec4.champions.common.item.ChampionEggItem;
import top.theillusivec4.champions.common.loot.EntityIsChampion;
import top.theillusivec4.champions.common.loot.LootItemChampionPropertyCondition;
import top.theillusivec4.champions.common.network.NetworkHandler;
import top.theillusivec4.champions.common.rank.RankManager;
import top.theillusivec4.champions.common.registry.ChampionsRegistry;
import top.theillusivec4.champions.common.stat.ChampionsStats;
import top.theillusivec4.champions.common.util.EntityManager;
import top.theillusivec4.champions.server.command.AffixArgument;
import top.theillusivec4.champions.server.command.ChampionSelectorOptions;
import top.theillusivec4.champions.server.command.ChampionsCommand;

@Mod(value="champions")
public class Champions {
    public static final String MODID = "champions";
    public static final Logger LOGGER = LogManager.getLogger();
    public static final IChampionsApi API = ChampionsApiImpl.getInstance();
    public static boolean scalingHealthLoaded = false;
    public static boolean gameStagesLoaded = false;

    public Champions() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.CLIENT, (IConfigSpec)ClientChampionsConfig.CLIENT_SPEC);
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ChampionsConfig.SERVER_SPEC);
        Champions.createServerConfig(ChampionsConfig.RANKS_SPEC, "ranks");
        Champions.createServerConfig(ChampionsConfig.AFFIXES_SPEC, "affixes");
        Champions.createServerConfig(ChampionsConfig.ENTITIES_SPEC, "entities");
        gameStagesLoaded = ModList.get().isLoaded("gamestages");
        if (gameStagesLoaded) {
            ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)ChampionsConfig.STAGE_SPEC, "champions-gamestages.toml");
        }
        IEventBus eventBus = FMLJavaModLoadingContext.get().getModEventBus();
        eventBus.addListener(this::config);
        eventBus.addListener(this::setup);
        eventBus.addListener(this::clientSetup);
        eventBus.addListener(this::registerCaps);
        MinecraftForge.EVENT_BUS.addListener(this::registerCommands);
        scalingHealthLoaded = ModList.get().isLoaded("scalinghealth");
    }

    private void setup(FMLCommonSetupEvent evt) {
        ChampionCapability.register();
        NetworkHandler.register();
        AffixManager.register();
        evt.enqueueWork(() -> {
            ChampionsStats.setup();
            ChampionSelectorOptions.setup();
            Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("champions:entity_champion"), (Object)EntityIsChampion.type);
            Registry.m_122965_((Registry)Registry.f_122877_, (ResourceLocation)new ResourceLocation("champions:champion_properties"), (Object)LootItemChampionPropertyCondition.INSTANCE);
            DispenseItemBehavior dispenseBehavior = (source, stack) -> {
                Direction direction = (Direction)source.m_6414_().m_61143_((Property)DispenserBlock.f_52659_);
                Optional<EntityType<?>> entitytype = ChampionEggItem.getType(stack);
                entitytype.ifPresent(type -> {
                    Entity entity = type.m_20655_(source.m_7727_(), stack.m_41783_(), null, null, source.m_7961_().m_142300_(direction), MobSpawnType.DISPENSER, true, direction != Direction.UP);
                    if (entity instanceof LivingEntity) {
                        ChampionCapability.getCapability(entity).ifPresent(champion -> ChampionEggItem.read(champion, stack));
                        source.m_7727_().m_7967_(entity);
                        stack.m_41774_(1);
                    }
                });
                return stack;
            };
            DispenserBlock.m_52672_((ItemLike)ChampionsRegistry.EGG, (DispenseItemBehavior)dispenseBehavior);
            ArgumentTypes.m_121601_((String)"champions:affix", AffixArgument.class, (ArgumentSerializer)new ArgumentSerializer<AffixArgument>(){

                public void serializeToNetwork(@Nonnull AffixArgument argument, @Nonnull FriendlyByteBuf buffer) {
                }

                @Nonnull
                public AffixArgument deserializeFromNetwork(@Nonnull FriendlyByteBuf buffer) {
                    return new AffixArgument();
                }

                public void serializeToJson(@Nonnull AffixArgument argument, @Nonnull JsonObject json) {
                }
            });
        });
    }

    private void clientSetup(FMLClientSetupEvent evt) {
        MinecraftForge.EVENT_BUS.register((Object)new ClientEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new ClientAffixEventsHandler());
        Minecraft.m_91087_().getItemColors().m_92689_(ChampionEggItem::getColor, new ItemLike[]{ChampionsRegistry.EGG});
        if (ModList.get().isLoaded("waila")) {
            WailaPlugin.setup();
        }
        evt.enqueueWork(() -> OverlayRegistry.registerOverlayTop((String)"Champions Health Bar", (IIngameOverlay)new ChampionsOverlay()));
    }

    private void registerCaps(RegisterCapabilitiesEvent evt) {
        evt.register(IChampion.class);
    }

    private void registerCommands(RegisterCommandsEvent evt) {
        ChampionsCommand.register((CommandDispatcher<CommandSourceStack>)evt.getDispatcher());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void config(ModConfigEvent evt) {
        if (evt.getConfig().getModId().equals(MODID)) {
            if (evt.getConfig().getType() == ModConfig.Type.SERVER) {
                Champions champions = this;
                synchronized (champions) {
                    ChampionsConfig.bake();
                    IConfigSpec spec = evt.getConfig().getSpec();
                    CommentedConfig commentedConfig = evt.getConfig().getConfigData();
                    if (spec == ChampionsConfig.RANKS_SPEC) {
                        ChampionsConfig.transformRanks(commentedConfig);
                        RankManager.buildRanks();
                    } else if (spec == ChampionsConfig.AFFIXES_SPEC) {
                        ChampionsConfig.transformAffixes(commentedConfig);
                        AffixManager.buildAffixSettings();
                    } else if (spec == ChampionsConfig.ENTITIES_SPEC) {
                        ChampionsConfig.transformEntities(commentedConfig);
                        EntityManager.buildEntitySettings();
                    }
                }
            } else if (evt.getConfig().getType() == ModConfig.Type.CLIENT) {
                ClientChampionsConfig.bake();
            }
        }
    }

    private static void createServerConfig(ForgeConfigSpec spec, String suffix) {
        String fileName = "champions-" + suffix + ".toml";
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)spec, fileName);
        File defaults = new File(FMLPaths.GAMEDIR.get() + "/defaultconfigs/" + fileName);
        if (!defaults.exists()) {
            try {
                FileUtils.copyInputStreamToFile((InputStream)Objects.requireNonNull(Champions.class.getClassLoader().getResourceAsStream(fileName)), (File)defaults);
            }
            catch (IOException e) {
                LOGGER.error("Error creating default config for " + fileName);
            }
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
        if (ModList.get().isLoaded("theoneprobe")) {
            LOGGER.info("Champions detected TheOneProbe, registering plugin now");
            InterModComms.sendTo((String)MODID, (String)"theoneprobe", (String)"getTheOneProbe", TheOneProbePlugin.GetTheOneProbe::new);
        }
    }
}

